function [segmentedImage, particles] = testLocalizerSegmentation(psfWidth, PFA, image)
% testLocalizerSegmentation provides an easy means to test the effect that
% particular segmentation parameters will have on the given input image.
%   This function is provided as a demonstration case that should make it
%   easy to introduce this functionality into your own code. Try playing
%   with the parameters and observing the segmentation difference.
%   
%   This function yields two outputs: the segmented image, which is a 2D
%   matrix of the same dimensions as the input matrix, in which a value of
%   255 denotes a pixel that is on (contains an emitter) whereas a value of
%   0 denotes a pixel that contains background.
%   The second output is a list of coordinates of the expected molecules
%   (which will serve as starting guesses in the localization analysis)
%   in a 4-column matrix. Every row in the matrix contains the following
%   information: estimated amplitude / x position / y position /
%   background.
    
    [segmentedImage, particles] = LocalizerMatlab('testsegmentation', psfWidth, 'GLRT', PFA, image);

end

